#!/usr/bin/env raku
use v6.d;

my %base  = <
:	ー
q	🆓
a	あ
s	お
d	え
f	う
g	い
z	っ
x	ん
c	が
b	🆓
wq	やい
ww	よう
we	いぇい
wr	ゆう
wt	ゆい
wa	や
ws	よ
wd	いぇ
wf	ゆ
wg	いぃ
wz	やん
wx	よん
wc	いぇん
wv	ゆん
wb	いぃん
vq	わい
vw	よう
ve	うぇい
vr	うー
vt	うぃー
va	わ
vs	を
vd	うぇ
vf	うぅ
vg	うぃ
vz	わん
vx	よん
vc	うぇん
vv	うぅん
vb	うぃん
uq	がい
uw	ごう
ue	げい
ur	ぐう
ut	ぐい
ua	が
us	ご
ud	げ
uf	ぐ
ug	ぎ
uz	がん
ux	ごん
uc	げん
uv	ぐん
ub	ぎん
iq	かい
iw	こう
ie	けい
ir	くう
it	くい
ia	か
is	こ
id	け
if	く
ig	き
iz	かん
ix	こん
ic	けん
iv	くん
ib	きん
oq	らい
ow	ろう
oe	れい
or	るう
ot	るい
oa	ら
os	ろ
od	れ
of	る
og	り
oz	らん
ox	ろん
oc	れん
ov	るん
ob	りん
pq	ぱい
pw	ぽう
pe	ぺい
pr	ぷう
pt	ぷい
pa	ぱ
ps	ぽ
pd	ぺ
pf	ぷ
pg	ぴ
pz	ぱん
px	ぽん
pc	ぺん
pv	ぷん
pb	ぴん
@q	ざい
@w	ぞう
@e	ぜい
@r	ずう
@t	ずい
@a	ざ
@s	ぞ
@d	ぜ
@f	ず
@g	じ
@z	ざん
@x	ぞん
@c	ぜん
@v	ずん
@b	じん
hq	だい
hw	どう
he	でい
hr	づう
ht	づい
ha	だ
hs	ど
hd	で
hf	づ
hg	ぢ
hz	だん
hx	どん
hc	でん
hv	づん
hb	ぢん
jq	はい
jw	ほう
je	へい
jr	ふう
jt	ふい
ja	は
js	ほ
jd	へ
jf	ふ
jg	ひ
jz	はん
jx	ほん
jc	へん
jv	ふん
jb	ひん
kq	たい
kw	とう
ke	てい
kr	つう
kt	つい
ka	た
ks	と
kd	て
kf	つ
kg	ち
kz	たん
kx	とん
kc	てん
kv	つん
kb	ちん
lq	ない
lw	のう
le	ねい
lr	ぬう
lt	ぬい
la	な
ls	の
ld	ね
lf	ぬ
lg	に
lz	なん
lx	のん
lc	ねん
lv	ぬん
lb	にん
;q	さい
;w	そう
;e	せい
;r	すう
;t	すい
;a	さ
;s	そ
;d	せ
;f	す
;g	し
;z	さん
;x	そん
;c	せん
;v	すん
;b	しん
nq	ばい
nw	ぼう
ne	べい
nr	ぶう
nt	ぶい
na	ば
ns	ぼ
nd	べ
nf	ぶ
ng	び
nz	ばん
nx	ぼん
nc	べん
nv	ぶん
nb	びん
mq	まい
mw	もう
me	めい
mr	むう
mt	むい
ma	ま
ms	も
md	め
mf	む
mg	み
mz	まん
mx	もん
mc	めん
mv	むん
mb	みん
>;

my @si = <u i o p @ h j k l ; n m>;

my @bo15 = <q w e r t a s d f g z x c v b>;
my @yo = <ゃい ょう ぇい ゅう ゃく ゃ ょ ぇ ゅ ょく ゃん ょん ぇん ゅん ぃ>;
my @ko = <ぁー ぉー ぇー ぅー ぃー ぁ ぉ ぇ ぅ ぃ ぁん ぉん ぇん ぅん ぃん>;
my @koy = <ゃー ょー ぇー ゅー ぃー ゃ ょ ぇ ゅ ぃ ゃん ょん ぇん ゅん ぃん>;

# どうしよっかなー。vf別対応する？
my @kof = <ぁい ぉー ぇい ゅー ぃー ぁ ぉ ぇ ゅ ぃ ぁん ぉん ぇん ゅん ぃん>;
my @kov = <ぁい ぉー ぇい ー ぃー ぁ ぉ ぇ>;
@kov.append('').append(<ぃ ぁん ぉん ぇん ん ぃん>);


my @ex = <ゅく ゅつ ゅっ> ;
my @exk= <i k ;>;

# FirsFinger ? or Not First FInger?
# my @ff  = <u h j n m>;      my $ffj = any(@ff);
# my @nff = <i o p @ k l ;>;  my $nffj= any(@nff);

# ガ行は人指以外の扱いにしたほうが打ちやすいです。
my @ff  = <h j n m>;      my $ffj = any(@ff);
my @nff = <u i o p @ k l ;>;  my $nffj= any(@nff);


sub あ($s,$ix) { %base{$s~'a'}   ~ @ko[$ix]  }
sub YOUON($s,$ix) { %base{$s~'g'} ~ @yo[$ix]  }
sub 合拗音($s,$ix) { %base{$s~'f'}  ~ @ko[$ix]  }
sub え($s,$ix) { %base{$s~'d'}  ~ @ko[$ix]  }
sub お($s,$ix) { %base{$s~'s'}  ~ @ko[$ix]  }

sub あy($s,$ix) { %base{$s~'a'}   ~ @koy[$ix]  }
sub 合拗音y($s,$ix) { %base{$s~'f'}  ~ @koy[$ix]  }
sub えy($s,$ix) { %base{$s~'d'}  ~ @koy[$ix]  }
sub おy($s,$ix) { %base{$s~'s'}  ~ @koy[$ix]  }


sub ex($s,$ix) { %base{$s ~ 'g'}  ~ @ex[$ix]  }

my %fffuns =
        'h' => &あ,
        ',' => &YOUON,
        '.' => &合拗音,
        'j' => &え,
        '/' => &お,
        'h,' => &あy,
        '.,' => &合拗音y,
        'j,' => &えy,
        '/,' => &おy,
        ;
my %nfffuns =
        'h' => &あ,
        'j' => &YOUON,
        '.' => &合拗音,
        ',' => &え,
        '/' => &お,
        'hj' => &あy,
        '.j' => &合拗音y,
        ',j' => &えy,
        '/j' => &おy,
        ;

sub 合拗音f($s,$ix) { %base{$s~'f'}  ~ @kof[$ix]  }
sub 合拗音v($s,$ix) { %base{$s~'f'}  ~ @kov[$ix]  }

my %nffvfuns = Map.new(%nfffuns,'.' => &合拗音v,);
my %nffffuns = Map.new(%nfffuns,'.' => &合拗音f,);

sub MAIN() {
    my $ff = open "長鳴き鳥配列-基本-拗音類.txt", :w ;
    my %f;
    my $vu2 = 'う゛'; # お好みで
    my $vu = 'ゔ';
    for @si -> $k1 {
        %f = %fffuns if $k1 ~~ $ffj;
        %f = %nfffuns if $k1 ~~ $nffj;
        for %f.keys -> $k2 {
            for ^@bo15.elems -> $c {
                my $key = $k1 ~ $k2 ~ @bo15[$c];
                my $out = %f{$k2}($k1,$c);
                # VF
                $out = %nffvfuns{$k2}($k1,$c)  if ($k1 ~ $k2 eq 'n.');
                $out = %nffffuns{$k2}($k1,$c)  if ($k1 ~ $k2 eq 'j.');
                $out = $out.subst(/ぶ/,$vu) if $k1 ~ $k2 eq 'n.' ;
                $out = $out.subst(/ぶ/,$vu) if $k1 ~ $k2 eq 'n.,' ;


                $ff.say("$key\t$out");
            }
            if %f{$k2}.WHICH eq &YOUON.WHICH {
                for ^@ex.elems -> $c {
                    my $key = $k1 ~ $k2 ~ @exk[$c];
                    my $out = ex($k1,$c);
                    $ff.say("$key\t$out");
                }
            }
        }
    }
    $ff.close;
}