#!/usr/bin/env raku
use v6.d;



#`[
#==================================配列の設定において重要なもの=======================================================
%gyo                            行。五段活用などのための情報
%gyo-next                       行。五段活用などのための情報。態を打たずに左側からNEUTRALの形を打てる点が%gyoと異なる。
%next-tai                       態。行の後に打つと行の活用方法が変わる機能のための情報
%keylayout                      行／態と結びついている実際に入力するキー情報
%gyo_keys                       以下同文
%next_keys                      以下同文
%tai_keys                       以下同文
%katachi                        形。活用の根本の音が定義されてある。 %sakippo に定義されてない文字列を書いても動きません！
%sakippo                        形。活用のさきっぽの音が定義されてある。%katachi に定義されてない文字列があってもスルーするだけで動作に影響はありません！
template-sakippo   ***()        形。うん。まあ。ごめん。形の定義がごちゃついてしまったこと。ここにお詫びします。誰によ？
template-next-verb ***()        接辞。ショートカットとして、動詞／形容詞そのものを格納する。この拡張の旨味の大きい部分。
                                この箇所のみ「raw key」なので、接辞ではqewrty layoutのキーを指定してください。
$***-***-junction               条件分岐用変数。これもごめん。むやみに乱立してもうた。
                                行をどの動詞活用として運用するのか？を判断するための空間。
                                たとえば敬語動詞活用を%gyoに追加／変更したいなら%gyoと$next-gyo-keigo-junctionの2箇所に記述する必要がある。



これは「行／態／形／接辞」で形成されている拡張です。




#=========================================================================================
定数を使ってるようで使ってない文字列代入が多いです。注意してください。。
<>による代入は変数が使えないですからねー。これのせいです。便利なんだかそうでないんだか。
]


constant $SP-ONE = 'SP-ONE';
constant $SP-TWO = 'SP-TWO';
constant $SP-THREE = 'SP-THREE';

constant $NEXT-SP-ONE = 'NEXT-SP-ONE';
constant $NEXT-SP-TWO = 'NEXT-SP-TWO';
constant $NEXT-SP-THREE = 'NEXT-SP-THREE';


constant $NEXT-ICHI-PO = 'NEXT-ICHI-PO';
constant $NEXT-ICHI-NE = 'NEXT-ICHI-NE';
constant $NEXT-SU-PO = 'NEXT-SU-PO';
constant $NEXT-SU-NE = 'NEXT-SU-NE';

constant $NEXT-V-W = 'NEXT-V-W';
constant $NEXT-V-K = 'NEXT-V-K';
constant $NEXT-V-G = 'NEXT-V-G';
# 使わない。いまのところは。
constant $NEXT-V-S = 'NEXT-V-S';
constant $NEXT-V-B = 'NEXT-V-B';
# 使わない。いまのところは。
constant $NEXT-V-M = 'NEXT-V-M';
constant $NEXT-V-R = 'NEXT-V-R';
constant $NEXT-V-MURU = 'NEXT-V-MURU';
# NEXT-PO でよいのでは？マップの右側がちがうので必要。
constant $NEXT-V-ARU = 'NEXT-V-ARU';
constant $NEXT-V-IKU = 'NEXT-V-IKU';
constant $NEXT-V-KURU = 'NEXT-V-KURU';
constant $NEXT-V-R-KEIGO = 'NEXT-V-R-KEIGO';
constant $NEXT-V-I = 'NEXT-V-I';
constant $NEXT-V-T = 'NEXT-V-T';

constant $gyo-godan-junction = any('k', 'g', 'z', 't', 'b', 'm', 'r', 'w',
        $NEXT-V-W, $NEXT-V-K, $NEXT-V-G, $NEXT-V-S, $NEXT-V-M, $NEXT-V-R, $NEXT-V-IKU, $NEXT-V-T, $NEXT-V-B
                                   );
constant $gyo-suru-junction = any('s');
constant $gyo-ichidan-junction = any('n', $NEXT-ICHI-PO, $NEXT-ICHI-NE, $NEXT-V-MURU);
constant $gyo-su-junction = any($NEXT-SU-NE, $NEXT-SU-PO);
constant $gyo-i-junction = any('h', $NEXT-V-I);
constant $gyo-na-junction = any('d');
constant $next-gyo-kuru-junction = any($NEXT-V-KURU);
constant $next-gyo-aru-junction = any($NEXT-V-ARU);
constant $next-gyo-keigo-junction = any($NEXT-V-R-KEIGO);


constant %next_keys = <
    NEXT-ICHI-PO ^6
    NEXT-ICHI-NE ^7
    NEXT-SU-PO ^8
    NEXT-SU-NE ^9
    NEXT-V-W ^v
    NEXT-V-K ^i
    NEXT-V-G ^u
    NEXT-V-S ^@
    NEXT-V-B ^[
    NEXT-V-M ^m
    NEXT-V-R ^o
    NEXT-V-MURU ^l
    NEXT-V-ARU ^j
    NEXT-V-IKU ^p
    NEXT-V-KURU ^n
    NEXT-V-R-KEIGO ^-
    NEXT-V-I ^0
    NEXT-V-T ^k
    NEXT-SP-ONE ^e
    NEXT-SP-TWO ^r
    NEXT-SP-THREE ^t
>.Hash;
constant $gyo-sp-junction = any($NEXT-SP-ONE, $NEXT-SP-TWO, $NEXT-SP-THREE, $SP-ONE, $SP-TWO, $SP-THREE,);
constant $next-po-junction = any($NEXT-ICHI-PO, $NEXT-SU-PO);
constant $next-ne-junction = any($NEXT-ICHI-NE, $NEXT-SU-NE);


# あまったキー p l y

# Mapのキー未定義回避のため、アクセスキーだけ登録した空のHashをもうけ結合させて使用する。これなら確実
sub template-gyo() {
    return { a => '', i => '', u => '', e => '', o => '', te => '', ta => '', NONE => '', meirei => '' }
}

constant %gyo =
k => { a => 'か', i => 'き', u => 'く', e => 'け', o => 'こ', te => 'いて', ta => 'いた', NONE => '', meirei => '' },
g => { a => 'が', i => 'ぎ', u => 'ぐ', e => 'げ', o => 'ご', te => 'いで', ta => 'いだ', NONE => '', meirei => '' },
s => Hash.new(template-gyo(), <a さ i し u す e せ o そ te して ta した >.Hash),
z => Hash.new(template-gyo(), <a さ i し u す e せ o そ te して ta した >.Hash),
t => Hash.new(template-gyo(), <a た i ち u つ e て o と te って ta った >.Hash),
b => Hash.new(template-gyo(), <a ば i び u ぶ e べ o ぼ te んで ta んだ >.Hash),
m => Hash.new(template-gyo(), <a ま i み u む e め o も te んで ta んだ >.Hash),
r => Hash.new(template-gyo(), <a ら i り u る e れ o ろ te って ta った >.Hash),
w => Hash.new(template-gyo(), <a わ i い u う e え o お te って ta った >.Hash),
n => { a => 'ら', i => '', u => 'る', e => 'れ', o => 'よ', te => 'て', ta => 'た', NONE => '', meirei => 'ろ' },
d => template-gyo, h => template-gyo,
;

constant %gyo-tai =
$NEXT-ICHI-PO => %gyo<n>,
$NEXT-ICHI-NE => %gyo<n>,
$NEXT-SU-PO => %gyo<z>,
$NEXT-SU-NE => %gyo<z>, ;

constant %gyo-next =
$NEXT-V-W => %gyo<w>,
$NEXT-V-K => %gyo<k>,
$NEXT-V-G => %gyo<g>,
$NEXT-V-S => %gyo<z>,
$NEXT-V-M => %gyo<m>,
$NEXT-V-R => %gyo<r>,
$NEXT-V-I => template-gyo,
# 変数まちがったらあかんよ。 => %gyo<i> とかないもの指定しても空なのでなんもおこらん。
$NEXT-V-T => %gyo<t>,
$NEXT-V-MURU => %gyo<n>,
$NEXT-V-IKU => { a => 'か', i => 'き', u => 'く', e => 'け', o => 'こ', te => 'って', ta => 'った', NONE => '', meirei => '' },
$NEXT-V-KURU => %gyo<k>,
$NEXT-V-ARU => { a => 'あら', i => 'あり', u => 'ある', e => 'あれ', o => 'あろ', te => 'あって', ta => 'あった', NONE => '', meirei => '' },
$NEXT-V-R-KEIGO => { a => 'ら', i => 'い', u => 'る', e => 'れ', o => 'ろ', te => 'って', ta => 'った', NONE => '', meirei => 'り' },
;
# ここはまだ工事中です。


constant $NEUTRAL-PO = 'NEUTRAL-PO';
constant $NEUTRAL-NE = 'NEUTRAL-NE';
constant $DEKI-PO = 'DEKI-PO';
constant $DEKI-NE = 'DEKI-NE';
constant $SASE-PO = 'SASE-PO';
constant $SASE-NE = 'SASE-NE';
constant $SASE-RARE-PO = 'SASE-RARE-PO';
constant $SASE-RARE-NE = 'SASE-RARE-NE';
constant $SARE-PO = 'SARE-PO';
constant $SARE-NE = 'SARE-NE';
constant $ASU-PO = 'ASU-PO';
constant $ASU-NE = 'ASU-NE';
constant %katachi_keys = <
    命令 4
    い g
    たり b
    現在 f
    現在丁寧 v
    れば丁寧 5
    ぬ 5
    たら丁寧 1
    過去丁寧 q
    過去 a
    たら z
    べき 2
    意思丁寧 w
    意思 s
    そう x
    て丁寧 3
    て d
    れば c
>.Hash;
constant %tai_keys = <
    NEUTRAL-PO k
    NEUTRAL-NE i
    DEKI-PO l
    DEKI-NE o
    SASE-PO m
    SASE-NE u
    SASE-RARE-PO n
    SASE-RARE-NE y
    ASU-PO :
    ASU-NE @
    SARE-PO ;
    SARE-NE p
>.hash;



constant %gyo_keys = <
    l y
    g u
    k i
    r o
    p p
    z @
    d h
    h j
    t k
    n l
    s ;
    - :
    b n
    m m
    w v
    y w
    , ,
    . .
    / /
    a a
    i g
    u f
    e d
    o s
    SP-ONE e
    SP-TWO r
    SP-THREE t
>.Hash;
constant %keylayout = (|%gyo_keys, |%katachi_keys, |%tai_keys, |%next_keys);



# IMAGE {$活用種別}{$態}{母音} == [母音に当てはまる動詞活用]
constant $KATU-ICHIDAN = 'KATU-ICHIDAN';
# 態にとっての統合相 無る = でき られ させ  (いく = い + KU = 一段 & って、った。  ら行をか行に置き換えればいい) %godan 内で完結できるだろう。
constant $KATU-GODAN = 'KATU-GODAN';
# 五段活用の統合相 NEUTRAL 限定なもののすべての行が通る道
constant $KATU-SU = 'KATU-SU';
constant $KATU-SURU = 'KATU-SURU';
constant $KATU-KURU = 'KATU-KURU';
constant $KATU-ARU = 'KATU-ARU';
constant $KATU-I = 'KATU-I';
constant $KATU-NA = 'KATU-NA';
constant $KATU-RU-KEIGO = 'KATU-RU-KEIGO';

# constant でMap を定義したところで
# .clone や (|%map1 |%map2) のように新しいマップを作ったところで、constant属性までコピーしちゃうみたいなので代入できないのよね。
# だから、mutable であるということを保証しないとならないみたい。なので for map.keys で全コピしてって形をとらないとconstantからコピーを取って一部をいじるのは難しいですね。
# my %template-sakippo-po = # てっとりばやいけど危険かも というわけでclosure が無難です。
sub mapadd(%h,Str $k,Str $v) {
    %h{$k} = $v;
    return %h;
};
sub template-sakippo-po() {
    # template closure function
    return {
        現在丁寧 => 'ます',
        過去丁寧 => 'ました',
        意思丁寧 => 'ましょう',
        たら丁寧 => 'ましたら',
        れば丁寧 => 'ますれば',
        て丁寧 => 'まして',
        べき => 'べき',
        たら => 'ら',
        たり => 'り',
        れば => 'ば',
        意思 => 'う',
        そう => 'そう',
        い => '',
        て => '',
        現在 => '',
        過去 => '',
        命令 => '' };
}
sub template-sakippo-ne() {
    return {
        現在丁寧 => 'ません',
        過去丁寧 => 'ませんでした',
        意思丁寧 => 'ませんよう',
        たら丁寧 => 'ずに',
        れば丁寧 => 'ぬ',
        ぬ => 'ぬ',
        ずに => 'ずに',
        て丁寧 => 'ないので',
        べき => 'べからず',
        たら => 'なかったら',
        たり => 'なかったり',
        そう => 'なさそう',
        れば => 'なければ',
        意思 => 'ないよう',
        い => '',
        # 否定肯定共通
        て => 'ないで',
        現在 => 'ない',
        過去 => 'なかった',
        命令 => 'な' };
}

sub template-sakippo-kuru-po() {
    my %h = template-sakippo-po;
    my (%a,%b,%r);
    sub ___(Str $s,$k) {
        %a{$k} = 'き' ~ $s  if any('ま',) ~~ $s.substr(0, 1);
    }
    ___(%h{$_}, $_) for %h.keys;
    %b =
            べき => 'くるべき',
            たら => 'きたら',
            たり => 'きたり',
            れば => 'くれば',
            意思 => 'こよう',
            そう => 'きそう',
            い => 'き',
            て => 'きて',
            現在 => 'くる',
            過去 => 'きた',
            命令 => 'こい';
    %r = Hash.new(%a, %b);
    #say %r;
    return %r;
}

sub template-sakippo-kuru-ne() {
    # 基本形を再利用するとして、どの方法が楽なんだろう？イレギュラーはやっぱり直打ちなんかなー
    # ひとつ言えることはこの方法もめんどくさいってこと。
    my %h = template-sakippo-ne;
    my %r;
    sub ___(Str $s --> Str) {
        return 'き' if '' eq $s;
        return 'くる' ~ $s  if 'な' eq $s;
        return 'き' ~ $s  if any('ま',) ~~ $s.substr(0, 1);
        return 'こ' ~ $s  if any('な', 'ず', 'ぬ') ~~ $s.substr(0, 1);
        return 'くる' ~ $s  if 'べ' ~~ $s.substr(0, 1);
        return $s;
    }
    %r{$_} = ___(%h{$_}) for %h.keys;
    return %r;
}
sub template-sakippo-da-po() {
    # @ALL_KATUYO = <たら たり 過去 意思 て 現在 現在丁寧 過去丁寧 意思丁寧 たら丁寧 て丁寧 そう 命令 れば い れば丁寧 べき>;
    return  { 現在丁寧 => 'です',
              過去丁寧 => 'でした',
              意思丁寧 => 'でしょう',
              たら丁寧 => 'でしたら',
              れば丁寧 => 'だけど',
              て丁寧 => 'でして',
              べき => 'だから',
              たら => 'だったら',
              たり => 'だったり',
              れば => 'であれば',
              意思 => 'だろう',
              そう => 'だそう',
              い => 'な',
              て => 'だって',
              現在 => 'だ',
              過去 => 'だった',
              命令 => 'だろ' }
}
sub template-sakippo-da-ne {
    return {
        現在丁寧 => 'ではありません',
        過去丁寧 => 'ではありませんでした',
        意思丁寧 => 'ではないでしょう',
        たら丁寧 => 'ではないのでしたら',
        れば丁寧 => 'ではないけど',
        て丁寧 => 'ではありませんので',
        べき => 'ではないから',
        たら => 'ではなかったら',
        たり => 'ではなかったり',
        れば => 'でなければ',
        意思 => 'ではないだろう',
        そう => 'ではなさそう',
        い => 'な',
        て => 'ではないので',
        現在 => 'ではない',
        過去 => 'ではなかった',
        命令 => 'ではないだろ'
    }
}
sub template-sakippo-i-po() {
    return  { 現在丁寧 => 'いです',
              過去丁寧 => 'いのでした',
              意思丁寧 => 'いでしょう',
              たら丁寧 => 'いのでしたら',
              れば丁寧 => 'さ',
              て丁寧 => 'いので',
              べき => 'さ',
              たら => 'かったら',
              たり => 'かったり',
              れば => 'ければ',
              意思 => 'いよう',
              そう => 'そう',
              い => 'く',
              て => 'くて',
              現在 => 'い',
              過去 => 'かった',
              命令 => 'くしろ' }
}
sub template-sakippo-i-ne {
    # 形容詞「イ=>ダ 型」 おおすじは「では=>く、で=>く」に置き換えられる。
    return {
        現在丁寧 => 'く',
        過去丁寧 => 'くありませんでした',
        意思丁寧 => 'くないでしょう',
        たら丁寧 => 'くないのでしたら',
        れば丁寧 => 'さ',
        て丁寧 => 'くありませんので',
        べき => 'さ',
        たら => 'くなかったら',
        たり => 'くなかったり',
        れば => 'くなければ',
        意思 => 'くないだろう',
        そう => 'くなさそう',
        い => 'くなく',
        て => 'くなくて',
        現在 => 'くない',
        過去 => 'くなかった',
        命令 => 'くするな'
    }
}
sub template-sakippo-aru-ne {
    return {
        現在丁寧 => 'ありません',
        過去丁寧 => 'ありませんでした',
        意思丁寧 => 'ありませんよう',
        たら丁寧 => 'あらずに',
        れば丁寧 => 'あらぬ',
        ぬ => 'あらぬ',
        ずに => 'あらずに',
        て丁寧 => 'ないので',
        べき => 'あるべからず',
        たら => 'なかったら',
        たり => 'なかったり',
        そう => 'なさそう',
        れば => 'なければ',
        意思 => 'ないよう',
        い => 'あり',
        # 否定肯定共通
        て => 'ないで',
        現在 => 'ない',
        過去 => 'なかった',
        命令 => 'な'
    };
}

sub template-sakippo-replace(%h,$bf,$af) {
    sub rep($t) {
        return $t.subst(/$bf/, $af)
    }
    my %r;
    %r{$_} = rep(%h{$_}) for %h.keys;
    return %r;
}


# これがあれば態の形をPairにせずに示せる。共通するものは明記するのが正解でしょう。
constant %sakippo =
GENE => {
    $NEUTRAL-PO => template-sakippo-po,
    $NEUTRAL-NE => template-sakippo-ne,
}, $KATU-SURU => {
    $NEUTRAL-PO => mapadd(mapadd(mapadd(mapadd(template-sakippo-po, '命令', 'ろ'), '意思', 'よう'), 'れば', 'れば'), '現在',
            'る'),
    $NEUTRAL-NE => mapadd(template-sakippo-ne, '命令', 'るな'),
}, $KATU-NA => {
    $NEUTRAL-PO => template-sakippo-da-po,
    $NEUTRAL-NE => template-sakippo-da-ne,
    $ASU-PO => template-sakippo-replace(template-sakippo-da-po, 'だ', 'じゃ'),
    $ASU-NE => template-sakippo-replace(template-sakippo-replace(template-sakippo-da-ne, 'では', 'じゃ'), 'いの', 'いん'),
}, $KATU-I => {
    $NEUTRAL-PO => template-sakippo-i-po,
    $NEUTRAL-NE => template-sakippo-i-ne,
}, $KATU-SU => { $NEUTRAL-PO => template-sakippo-po, $NEUTRAL-NE => template-sakippo-ne,
}, $KATU-KURU => { $NEUTRAL-PO => template-sakippo-kuru-po(), $NEUTRAL-NE => template-sakippo-kuru-ne(),
}, $KATU-ARU => { $NEUTRAL-PO => template-sakippo-po, $NEUTRAL-NE => template-sakippo-aru-ne }, $KATU-RU-KEIGO => { $NEUTRAL-PO => mapadd(
        template-sakippo-po, '意思', 'よう'), $NEUTRAL-NE => template-sakippo-ne };

constant @ALL_KATUYO = <たら たり 過去 意思 て 現在 現在丁寧 過去丁寧 意思丁寧 たら丁寧 て丁寧 そう 命令 れば い れば丁寧 べき>;


# u =><現在> , 要素数が1つだけだとStr扱いとなり配列として引数渡したらType checkエラーになる！なので[]で囲みましょう。
# u => ''  これも同様にMapにするとき配列扱いされない(あたりまえだが？)ので、空ならこっち[]

constant %katachi =
$KATU-GODAN => {
    $NEUTRAL-PO => {
        meirei => [], NONE => [], a => [],
        i => <現在丁寧 過去丁寧 意思丁寧 たら丁寧 れば丁寧 て丁寧 い そう>,
        u => ['現在', 'べき'], e => <れば 命令>, o => ['意思'], te => ['て'], ta => <たら たり 過去>,
    },
    $NEUTRAL-NE => {
        meirei => [], NONE => [],
        a => <たら たり そう 現在 れば て 過去 意思 たら丁寧 て丁寧 れば丁寧>,
        i => <現在丁寧 過去丁寧 意思丁寧 い>,
        u => ['命令', 'べき'], e => [], o => [], te => [], ta => [],
    },
}, $KATU-ICHIDAN => {
    $NEUTRAL-PO => {
        NONE => [], a => [], u => ['現在', 'べき'],
        e => ['れば'], o => ['意思'], meirei => ['命令'], te => ['て'],
        ta => <たら たり 過去>,
        i => <現在丁寧 過去丁寧 意思丁寧 たら丁寧 れば丁寧 て丁寧 い そう>
    }, $NEUTRAL-NE => {
        meirei => [], a => [], e => [], o => [], te => [], ta => [], NONE => [],
        i => ['現在丁寧', '過去丁寧', '意思丁寧', 'い', 'たら丁寧', 'て丁寧', 'たら', 'たり', 'そう', '現在', 'れば', 'て', '過去', '意思', 'れば丁寧'],
        u => ['命令'],
    },
}, $KATU-SURU => { # ==========================する==============
    $NEUTRAL-PO => {
        meirei => [], NONE => [],
        a => [],
        u => ['現在', 'れば','べき'],
        e => [],
        o => [],
        te => ['て'],
        ta => <たら たり 過去>,
        i => <現在丁寧 過去丁寧 意思丁寧 たら丁寧 れば丁寧 て丁寧 い そう 命令 意思>
    }, $NEUTRAL-NE => {
        meirei => [], NONE => [], a => [],
        i => <現在丁寧 過去丁寧 意思丁寧 い たら たり そう 現在 れば て 過去 意思>,
        u => ['命令','べき'], e => ['たら丁寧'], o => [], te => [], ta => [],
    }
}, $KATU-SU => { #否定形以外一段活用と同じ。
    $NEUTRAL-PO => {
        NONE => [], a => [],
        u => ['現在', 'べき'], e => ['れば'], o => ['意思'], meirei => ['命令'], te => ['て'], ta => <たら たり 過去 >,
        i => <現在丁寧 過去丁寧 意思丁寧 たら丁寧 れば丁寧 て丁寧 い そう>
    }, $NEUTRAL-NE => {
        meirei => [], a => ['たら丁寧', '現在', 'たら', 'たり', 'そう', 'れば', 'れば丁寧', 'て丁寧', 'て', '過去', '意思'], e => [], o => [], te => [], ta => [], NONE => [],
        i => ['現在丁寧', '過去丁寧', '意思丁寧', 'い'], u => ['命令'],
    },
}, $KATU-NA => {
    # ==========================ダ==============
    $NEUTRAL-PO => { meirei => [], a => [], i => [], u => [], e => [], o => [], te => [], ta => [], NONE => @ALL_KATUYO,
    }, $NEUTRAL-NE => { meirei => [], a => [], i => [], u => [], e => [], o => [], te => [], ta => [], NONE => @ALL_KATUYO,
    }, $ASU-PO => { meirei => [], a => [], i => [], u => [], e => [], o => [], te => [], ta => [], NONE => @ALL_KATUYO,
    }, $ASU-NE => { meirei => [], a => [], i => [], u => [], e => [], o => [], te => [], ta => [], NONE => @ALL_KATUYO,
    },
    # その他の態は、gyo-to-tai()で設定しましょう。
}, $KATU-I => {
    $NEUTRAL-PO => { meirei => [], a => [], i => [], u => [], e => [], o => [], te => [], ta => [], NONE => @ALL_KATUYO,
    }, $NEUTRAL-NE => { meirei => [], a => [], i => [], u => [], e => [], o => [], te => [], ta => [], NONE => @ALL_KATUYO,
    },
    # その他の態は、gyo-to-tai()で設定しましょう。
}, $KATU-KURU => {
    $NEUTRAL-PO => { meirei => [], a => [], i => [], u => [], e => [], o => [], te => [], ta => [], NONE => @ALL_KATUYO,
    }, $NEUTRAL-NE => { meirei => [], a => [], i => [], u => [], e => [], o => [], te => [], ta => [], NONE => @ALL_KATUYO,
    },
}, $KATU-ARU => {
    # 5段と一緒でよい。ただ否定形は語幹とは関係ない。
    $NEUTRAL-PO => {
        meirei => [], NONE => [], a => [], i => <現在丁寧 過去丁寧 意思丁寧 たら丁寧 れば丁寧 て丁寧 い そう>,
        u => ['現在', 'べき'], e => <れば 命令>, o => ['意思'], te => ['て'], ta => <たら たり 過去>,
    }, $NEUTRAL-NE => { meirei => [], a => [], i => [], u => [], e => [], o => [], te => [], ta => [], NONE => @ALL_KATUYO, }
}, $KATU-RU-KEIGO => {
    $NEUTRAL-PO => {
        meirei => ['命令'], NONE => [], a => [], i => <現在丁寧 過去丁寧 意思丁寧 たら丁寧 れば丁寧 て丁寧 い そう>,
        u => ['現在', 'べき', '意思'], e => ['れば'], o => [], te => ['て'], ta => <たら たり 過去>,
    },
    #$NEUTRAL-NE => { meirei => [], a => [], i => [], u => [], e => [], o => [], te => [], ta => [], NONE => @ALL_KATUYO,}
    $NEUTRAL-NE => {
        meirei => [], NONE => [], a => <れば丁寧 そう 現在 過去 意思 たり たら て たら丁寧>,
        i => <現在丁寧 過去丁寧 意思丁寧 い>,
        u => ['命令'], e => ['れば'], o => [], te => [], ta => [],
    }
},
;

# なんで直打ちなん？訂正してよ。
constant %next-tai =
$KATU-GODAN => {
    'a' => {
        $SASE-PO => ['せ', $NEXT-ICHI-PO],
        $SASE-NE => ['せ', $NEXT-ICHI-NE],
        $SASE-RARE-PO => ['せられ', $NEXT-ICHI-PO],
        $SASE-RARE-NE => ['せられ', $NEXT-ICHI-NE],
        $SARE-PO => ['れ', $NEXT-ICHI-PO],
        $SARE-NE => ['れ', $NEXT-ICHI-NE],
        $ASU-PO => ['', $NEXT-SU-PO],
        $ASU-NE => ['', $NEXT-SU-NE],
    }, 'e' => {
        $DEKI-PO => ['', $NEXT-ICHI-PO],
        $DEKI-NE => ['', $NEXT-ICHI-NE],
    },
}, $KATU-RU-KEIGO => {
    'a' => {
        $SASE-PO => ['せ', $NEXT-ICHI-PO],
        $SASE-NE => ['せ', $NEXT-ICHI-NE],
        $SASE-RARE-PO => ['せられ', $NEXT-ICHI-PO],
        # くどすぎる日本語。おっしゃ-らせられ-ました
        $SASE-RARE-NE => ['せられ', $NEXT-ICHI-NE],
        $SARE-PO => ['れ', $NEXT-ICHI-PO],
        $SARE-NE => ['れ', $NEXT-ICHI-NE],
        $ASU-PO => ['', $NEXT-SU-PO],
        $ASU-NE => ['', $NEXT-SU-NE],
        $DEKI-PO => ['れ', $NEXT-ICHI-PO],
        $DEKI-NE => ['れ', $NEXT-ICHI-NE],
    }
}, $KATU-SURU => {
    'a' => {
        $SASE-PO => ['せ', $NEXT-ICHI-PO],
        $SASE-NE => ['せ', $NEXT-ICHI-NE],
        $SASE-RARE-PO => ['せられ', $NEXT-ICHI-PO],
        $SASE-RARE-NE => ['せられ', $NEXT-ICHI-NE],
        $SARE-PO => ['れ', $NEXT-ICHI-PO],
        $SARE-NE => ['れ', $NEXT-ICHI-NE],
        $ASU-PO => ['', $NEXT-SU-PO],
        $ASU-NE => ['', $NEXT-SU-NE],
    }, 'NONE' => {
        $DEKI-PO => ['でき', $NEXT-ICHI-PO],
        $DEKI-NE => ['でき', $NEXT-ICHI-NE],
    }
}, $KATU-KURU => {
    'o' => {
        $SASE-PO => ['させ', $NEXT-ICHI-PO],
        $SASE-NE => ['させ', $NEXT-ICHI-NE],
        $SASE-RARE-PO => ['させられ', $NEXT-ICHI-PO],
        $SASE-RARE-NE => ['させられ', $NEXT-ICHI-NE],
        $SARE-PO => ['られ', $NEXT-ICHI-PO],
        $SARE-NE => ['られ', $NEXT-ICHI-NE],
        $ASU-PO => ['さ', $NEXT-SU-PO],
        $ASU-NE => ['さ', $NEXT-SU-NE],
        $DEKI-PO => ['られ', $NEXT-ICHI-PO],
        $DEKI-NE => ['られ', $NEXT-ICHI-NE],
    }
}, $KATU-ICHIDAN => {
    'NONE' => {
        $SASE-PO => ['させ', $NEXT-ICHI-PO],
        $SASE-NE => ['させ', $NEXT-ICHI-NE],
        $SASE-RARE-PO => ['させられ', $NEXT-ICHI-PO],
        $SASE-RARE-NE => ['させられ', $NEXT-ICHI-NE],
        $SARE-PO => ['され', $NEXT-ICHI-PO],
        $SARE-NE => ['され', $NEXT-ICHI-NE],
        $ASU-PO => ['さ', $NEXT-SU-PO],
        $ASU-NE => ['さ', $NEXT-SU-NE],
        $DEKI-PO => ['られ', $NEXT-ICHI-PO],
        $DEKI-NE => ['られ', $NEXT-ICHI-NE],
    }
}, $KATU-ARU => {
    # 実際はこんな活用日常語じゃありえないんだがなー。改まりすぎですって。
    'a' => {
        $SASE-PO => ['せ', $NEXT-ICHI-PO],
        $SASE-NE => ['せ', $NEXT-ICHI-NE],
        $SASE-RARE-PO => ['せられ', $NEXT-ICHI-PO],
        $SASE-RARE-NE => ['せられ', $NEXT-ICHI-NE],
        $SARE-PO => ['れ', $NEXT-ICHI-PO],
        $SARE-NE => ['れ', $NEXT-ICHI-NE],
        $ASU-PO => ['', $NEXT-SU-PO],
        $ASU-NE => ['', $NEXT-SU-NE],
    }, 'i' => {
        # ありえる
        # この形式は「おこる -> おこりえない」とかでも使いたいなー。
        # まあ「おこれない」とかち合うからそうはいかないんだけどね。
        # 「起こる」と「怒る」は厳密には別物ってことさ。「怒る」は「える」と複合化できないんさ。
        # とはいえまだまだ進化の余地があるということさ。
        $DEKI-PO => ['え', $NEXT-ICHI-PO],
        $DEKI-NE => ['え', $NEXT-ICHI-NE],
    },
}, $KATU-I => {
    # ちょっとぜいたくすぎるかなー？とも思うけど、ほかの「行／態／形」と同じリズムを保つにはこれらに態につなげさせるわけにはいかなかった。
    # これらにほかの態を打たせることもできるっちゃできるけど、「行／態／態／形」なんて頭こんがらがるって。「行／態／態／接辞」なんて右4連打だしね。
    'NONE' => {
        $SASE-PO => ['くみえ', $NEXT-V-MURU, $NEUTRAL-PO],
        $SASE-NE => ['くみえ', $NEXT-V-MURU, $NEUTRAL-NE],
        $SASE-RARE-PO => ['く', $NEXT-V-ARU, $NEUTRAL-PO],
        $SASE-RARE-NE => ['く', $NEXT-V-ARU, $NEUTRAL-NE],
        $SARE-PO => ['く', 's', $NEUTRAL-PO],
        $SARE-NE => ['く', 's', $NEUTRAL-NE],
        $ASU-PO => ['が', $NEXT-V-R, $NEUTRAL-PO],
        $ASU-NE => ['が', $NEXT-V-R, $NEUTRAL-NE],
        $DEKI-PO => ['くな', $NEXT-V-R, $NEUTRAL-PO],
        $DEKI-NE => ['くな', $NEXT-V-R, $NEUTRAL-NE],
    }
}, $KATU-NA => {
    'NONE' => {
        $SASE-PO => ['にみえ', $NEXT-V-MURU, $NEUTRAL-PO],
        $SASE-NE => ['にみえ', $NEXT-V-MURU, $NEUTRAL-NE],
        $SASE-RARE-PO => ['に', $NEXT-V-ARU, $NEUTRAL-PO],
        $SASE-RARE-NE => ['に', $NEXT-V-ARU, $NEUTRAL-NE],
        $SARE-PO => ['に', 's', $NEUTRAL-PO],
        $SARE-NE => ['に', 's', $NEUTRAL-NE],
        #        $ASU-PO => ['が' , $NEXT-V-R, $NEUTRAL-PO], 「ジャ」です
        #        $ASU-NE => ['が' , $NEXT-V-R, $NEUTRAL-NE], 「ジャ」です
        $DEKI-PO => ['にな', $NEXT-V-R, $NEUTRAL-PO],
        $DEKI-NE => ['にな', $NEXT-V-R, $NEUTRAL-NE],
    }

};


sub choose-sakippo(Str $katu, Str $tai) {
    # {returns Hash {
    my $k = $katu ~~ any($KATU-GODAN, $KATU-ICHIDAN) ?? 'GENE' !! $katu;
    return %sakippo{$k}{$tai};
    #    say '[choose-sakippo]: sakippoがみつかりません。',"\$katu = $katu\t \$tai = $tai\t %p" if !so %p;
    #    # say "$katu\t$tai\t",%p.WHAT,"\t [from choose-sakippo]";
    #    return %p;
}
sub choose-katu(Str $si) returns Str {
    return $KATU-I if $si ~~ $gyo-i-junction;
    return $KATU-NA if $si ~~ $gyo-na-junction;
    return $KATU-SURU if $si ~~ $gyo-suru-junction;
    return $KATU-RU-KEIGO if $si ~~ $next-gyo-keigo-junction;
    return $KATU-ARU if $si ~~ $next-gyo-aru-junction;
    return $KATU-KURU if $si ~~ $next-gyo-kuru-junction;
    return $KATU-SU if $si ~~ $gyo-su-junction;
    return $KATU-GODAN if $si ~~ $gyo-godan-junction;
    return $KATU-ICHIDAN if $si ~~ $gyo-ichidan-junction;
    say '[choose-katu]: 活用がみつかりません。', "\$si = $si";
}
multi sub get-gyo-keys(@strarr) returns Str {
    my Str $result;
    sub ___(@arr) returns Str {
        return $result if !so @arr;
        $result ~= %keylayout{@arr[0]}  if %keylayout{@arr[0]}:exists;
        return  ___(@arr[1 ..*]);
    }(@strarr);
    return $result;
}

# どこかでつかったのを壊すのも忍びない。汎用性ないっすから壊してもいいのだけれど。
multi sub get-gyo-keys(Str $k) returns Str {
    my Str $result;
    return %keylayout{$k} if $k.chars == 1;
    return %keylayout{$k} if %keylayout{$k}:exists;
    sub ___(@arr) returns Str {
        return $result if !so @arr;
        $result ~= %keylayout{@arr[0]};
        return  ___(@arr[1 ..*]);
    }($k.comb);
    return $result if so $result;
    say '[get-gyo-keys]: $k ってなんですか？';
}


sub oto-no-katachi(%g,Str $si, Str $bo,Str $katu, Str $tai) returns Array of Str {
    my @result of Str;
    my %p = choose-sakippo($katu, $tai);
    sub ___(@arr) returns Array of Str {
        return @result if !so @arr;
        my $s of Str = '';
        #        say @arr[0];
        # Hashから空文字を取得して文字列として結合すると警告がでるので対応したまでだ。
        $s = %g{$si}{$bo} if so %g{$si}{$bo};
        $s ~= %p{@arr[0]} if so %p{@arr[0]};
        @result.append($s);
        return  ___(@arr[1 ..*]);
    }(%katachi{$katu}{$tai}{$bo});
}
sub oto-no-katachi-keys(Str $si, Str $bo,Str $katu, Str $tai,Bool $on-tai-key) returns Array of Str {
    my @result of Str;
    sub ___(@arr) returns Array of Str {
        return @result if !so @arr;
        my $s of Str;
        $s = $on-tai-key ?? %keylayout{$si} ~ %keylayout{$tai} ~ %katachi_keys{@arr[0]} !! get-gyo-keys($si) ~ %keylayout{@arr[0]};

        # say $si,"\t",%keylayout{$si},"\t",%keylayout{@arr[0]};
        @result.append($s);
        return  ___(@arr[1 ..*]);
    }(%katachi{$katu}{$tai}{$bo});
    # key は Array で保持しておいたほうが保守性高いんだが、まあ別にこれでも困らんよな・・・
}
sub gyo-katachi(%g,Str $si,Str $katu, Str $tai) returns Array of Str {
    my @result of Str;
    sub ___(@arr) {
        return @result if !so @arr;
        @result.append(oto-no-katachi(%g, $si, @arr[0], $katu, $tai));
        return  ___(@arr[1 ..*]);
    }(%g{$si}.keys);
}
sub gyo-katachi-keys(%g,Str $si,Str $katu, Str $tai,Bool $on-tai-key) returns Array of Str {
    my @result of Str;
    sub ___(@arr) {
        return @result if !so @arr;
        @result.append(oto-no-katachi-keys($si, @arr[0], $katu, $tai, $on-tai-key));
        return  ___(@arr[1 ..*]);
    }(%g{$si}.keys);
}

sub ironna-katachi(%g) returns Hash {
    # gyo-katachi内の態を読めばいいんですよ。
    my @godan-result-keys;
    my @godan-result-outputs;
    # なんでも活用なんでも態
    for %g.keys -> $gyok {
        my $katu = choose-katu($gyok);
        for %katachi{$katu}.keys -> $tai {
            @godan-result-outputs.append(gyo-katachi(%g, $gyok, $katu, $tai));
            @godan-result-keys.append(gyo-katachi-keys(%g, $gyok, $katu, $tai, True));
        }
    }
    return result-print(@godan-result-keys, @godan-result-outputs);
}

sub left-default-katachi(%g,Str $tai) returns Hash {
    sub choose-tai($k,$tai) {
        return $tai if $tai ne '';
        return $NEUTRAL-PO if $k ~~ $next-po-junction;
        return $NEUTRAL-NE if $k ~~ $next-ne-junction;
        say "[choose-tai]: その他の態です。要書き直し対応\t\$k is $k";
    }
    # 否定形をデフォルトにしたくなるかもしれないし、可能態をデフォルトにしたくなるかもしれない。
    # そのように考えたとき、 態は任意のほうがよいだろう。
    # 活用を判定しneutralの形をみつくろう。
    my @godan-result-keys;
    my @godan-result-outputs;
    # なんでも活用ニュートラル
    @godan-result-outputs.append(gyo-katachi(%g, $_, choose-katu($_), choose-tai($_, $tai))) for %g.keys;
    @godan-result-keys.append(gyo-katachi-keys(%g, $_, choose-katu($_), choose-tai($_, $tai), False)) for %g.keys;
    #    say @godan-result-outputs;
    #    say @godan-result-keys;
    return result-print(@godan-result-keys, @godan-result-outputs);
}
sub gyo-to-tai(%g) returns Hash {
    my (@k,@o,@n);
    sub injection($k,$o,$n) {
        @k.append($k);
        @o.append($o);
        @n.append($n);
    }
    my Str ($k,$o,$n);

    sub _1(@si) {
        return if !so @si;
        my $katu = choose-katu(@si[0]);
        # 活用を取得
        return  _1(@si[1 ..*]) if not %next-tai{$katu}:exists;
        # 活用がなければスルー

        sub _2(@bo) {
            return if !so @bo;
            sub _3(@tai) {
                return if !so @tai;
                $o = %g{@si[0]}{@bo[0]}:exists ?? %g{@si[0]}{@bo[0]} !! '';
                $o ~= %next-tai{$katu}{@bo[0]}{@tai[0]}[0];
                $k = %keylayout{@si[0]} ~ %keylayout{@tai[0]};

                $n = get-gyo-keys(%next-tai{$katu}{@bo[0]}{@tai[0]}[1 ..*]);

                injection($k, $o, $n);
                # existsでチェックしないとANY代入の警告あります。　原因はこいつ → say %g{@si[0]}{@bo[0]};
                # $si[0]が「s」「n」で、$boが「NONE」のときに起こるようです。
                # %gyo に NONE を登録してなかったのが根本的な原因ですね。
                # ということで%gyo側にも問題回避策を講じました。
                return  _3(@tai[1 ..*]);
            }(%next-tai{$katu}{@bo[0]}.keys);
            return  _2(@bo[1 ..*]);
        }(%next-tai{$katu}.keys);
        return  _1(@si[1 ..*]);
    }(%g.keys);
    return result-print(@k, @o, @n);
}

multi sub result-print(@keys,@outputs) returns Hash {
    my %result-hash;
    my $c;
    sub ___(@arr,@brr) {
        return if !so @arr;
        %result-hash{@arr[0]} = [@brr[0], ''];
        say $c++, "\t", @arr[0], "\t", @brr[0];
        return  ___(@arr[1 ..*], @brr[1 ..*]);
    }(@keys, @outputs);
    return %result-hash;
}
multi sub result-print(@keys,@outputs,@nexts) {
    # returns Hash {
    my %result-hash;
    my $c;
    sub ___(@arr,@brr,@crr) {
        return if !so @arr;
        %result-hash{@arr[0]} = [@brr[0], @crr[0]];
        say $c++, "\t", @arr[0], "\t", @brr[0], "\t", @crr[0];
        return  ___(@arr[1 ..*], @brr[1 ..*], @crr[1 ..*],);
    }
    ___(@keys, @outputs, @nexts);
    return %result-hash;
}

#`[
# 「⭐」と「❤️🔪」配置 2024年1月7日 Version

⭐E & Triple(RIGHT only)

| 1   | 2   | 3   | 4   | 5   | 6   | 7   | 8   | 9   | 0   | \-  |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
| わかるAW | よい❇️O | いらっしゃる | いただく➿ | ござる | ☠️おっしゃる | あげる➿ | おく  | なる  | おる  | かんじる |
| はなすA | おもうO | かんがえるE | やる  | かえる➿ | つかう | ある  | いく  | いる➿ | しまう | ☠️  |
| くださる➿ | しょうがない❇️O | しかたない❇️ | わるい❇️W | ☠️たまらない❇️ | くる  | みる  | くれる | もらう | ☠️  |     |
| 小指  | 薬指  | 中指  | 人   | 人   | 人   | 人   | 中   | 薬   | 小   | 小   |

❤️R

| 1   | 2   | 3   | 4   | 5   | 6   | 7   | 8   | 9   | 0   | \-  |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
| あやまる  <br>🟦A | ない❇️🟨 | たてる | かわる | まわる | ☠️こなす  <br>🟪 | がたい  <br>❇️G | かける🟩C | なれる  <br>🟪NR | おとす | たがる®️ |
| あきる  <br>🟥🤑 | たい❇️🟩 | つく🟨 | さる🟨 | まわす | づらい  <br>❇️D | ほしい  <br>❇️ | つける🟩T | にくい  <br>❇️N | すぎる  <br>🟥🤑S | ☠️  |
| かかる🟩 | たつ  | でる  | かねる  <br>🟦 | ☠️あぐねる⬜ | やすい  <br>❇️B | まくる  <br>🟧🤑M | 忘れる🟥W | ぬく  <br>🟨N | ☠️  |     |
| 小指  | 薬指  | 中指  | 人   | 人   | 人   | 人   | 中   | 薬   | 小   | 小   |

🔪T

| 1   | 2   | 3   | 4   | 5   | 6   | 7   | 8   | 9   | 0   | \-  |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
| あがる | とるO | いれるE | いただく  <br>➿ | かえす | そびれる🟦 | あげる➿G | きる🟨C | 遅れる  <br>🟥R | なおす  <br>🟧🤑 | やがる®️ |
| あう🎭A  <br>あわす  <br>あわせる | こむ🤑O | える🎭E | そこなう  <br>🟦 | かえる  <br>➿ | だす🟩D | 始める  <br>🟩H | 続ける  <br>🟪T | のこす  <br>🟥N | つくす  <br>🟨S |     |
| くださる➿ | おろすO | わけるE | そこねる  <br>🟦 | ☠️そんじる⬜ | とおす🟨B | まちがう  <br>🟦M | 終わる  <br>🟨W | 終える  <br>🟨V | ☠️  |     |
| 小指  | 薬指  | 中指  | 人   | 人   | 人   | 人   | 中   | 薬   | 小   | 小   |



]
# ====================================================================
sub template-next-verb-te-e(Str $si) {
    # E 位置から発生するマッピング
    #    return {} if $gyo-i-junction ~~ $si;
    #    return {} if $gyo-na-junction ~~ $si;
    return {
        'y' => ['おっしゃ', $NEXT-V-R-KEIGO],
        'u' => ['あげ', $NEXT-V-MURU],
        'i' => ['お', $NEXT-V-K],
        'o' => ['な', $NEXT-V-R],
        'p' => ['お', $NEXT-V-R],
        '@' => ['かんじ', $NEXT-V-MURU],
        #'h' => ['つか', $NEXT-V-W],
        'h' => ['や', $NEXT-V-R],
        'j' => ['', $NEXT-V-ARU],
        'k' => ['い', $NEXT-V-IKU],   # 特別扱い。「いいて」じゃなく「いって」
        'l' => ['い', $NEXT-V-MURU],
        ';' => ['しま', $NEXT-V-W],
        'n' => ['', $NEXT-V-KURU],
        'm' => ['み', $NEXT-V-MURU],
        ',' => ['くれ', $NEXT-V-MURU],
        '.' => ['もら', $NEXT-V-W],
    }
}



sub template-next-verb-i-r(Str $si) {
    # R 位置から発生するマッピング
    #return {} if $gyo-i-junction ~~ $si;
    #return {} if $gyo-na-junction ~~ $si;
    return {
        '2' => ['たまわ', $NEXT-V-R],
        '3' => ['たま', $NEXT-V-W],

        'q' => ['あやま', $NEXT-V-R],
        'w' => ['な', $NEXT-V-I],
        'e' => ['たて', $NEXT-V-MURU],
        'r' => ['かわ', $NEXT-V-R],
        't' => ['まわ', $NEXT-V-R],
        'a' => ['あき', $NEXT-V-MURU],
        's' => ['た', $NEXT-V-I],
        'd' => ['つ', $NEXT-V-K],
        'f' => ['さ', $NEXT-V-R],
        'g' => ['まわ', $NEXT-V-S],
        'z' => ['かか', $NEXT-V-R],
        'x' => ['た', $NEXT-V-T],
        'c' => ['で', $NEXT-V-MURU],
        'v' => ['かね', $NEXT-V-MURU],
        'b' => ['あぐね', $NEXT-V-MURU],

        'y' => ['こな', $NEXT-V-S],
        'u' => ['がた', $NEXT-V-I],
        'i' => ['かけ', $NEXT-V-MURU],
        'o' => ['なれ', $NEXT-V-MURU],
        'p' => ['おと', $NEXT-V-S],
        '@' => ['たが', $NEXT-V-R],
        'h' => ['づら', $NEXT-V-I],
        'j' => ['ほし', $NEXT-V-I],
        'k' => ['つけ', $NEXT-V-MURU],
        'l' => ['にく', $NEXT-V-I],
        ';' => ['すぎ', $NEXT-V-MURU],
        'n' => ['やす', $NEXT-V-I],
        'm' => ['まく', $NEXT-V-R],
        ',' => ['わすれ', $NEXT-V-MURU],
        '.' => ['ぬ', $NEXT-V-K],
    }
}
sub template-next-verb-i-t(Str $si) {
    # T 位置から発生するマッピング
    # return {} if $gyo-i-junction ~~ $si;
    # return {} if $gyo-na-junction ~~ $si;
    return {
        '2' => ['うけたまわ', $NEXT-V-R],
        '3' => ['もう', $NEXT-V-S],

        'q' => ['あが', $NEXT-V-R],
        'w' => ['と', $NEXT-V-R],
        'e' => ['いれ', $NEXT-V-MURU],
        'r' => ['いただ', $NEXT-V-K],
        't' => ['かえ', $NEXT-V-S],
        'a' => ['あ', $NEXT-V-W],
        's' => ['こ', $NEXT-V-M],
        'd' => ['え', $NEXT-V-MURU],
        'f' => ['そこな', $NEXT-V-W],
        'g' => ['かえ', $NEXT-V-MURU],
        # い-変える is 一段R     て-返る/帰る  is 五段R
        'z' => ['くださ', $NEXT-V-R-KEIGO],
        'x' => ['おろ', $NEXT-V-S],
        'c' => ['わけ', $NEXT-V-MURU],
        'v' => ['そこね', $NEXT-V-MURU],
        'b' => ['そんじ', $NEXT-V-MURU],

        'y' => ['そびれ', $NEXT-V-MURU],
        'u' => ['あげ', $NEXT-V-MURU],
        'i' => ['き', $NEXT-V-R],
        'o' => ['おくれ', $NEXT-V-MURU],
        'p' => ['なお', $NEXT-V-S],
        '@' => ['やが', $NEXT-V-R],
        'h' => ['だ', $NEXT-V-S],
        'j' => ['はじめ', $NEXT-V-MURU],
        'k' => ['つづけ', $NEXT-V-MURU],
        'l' => ['のこ', $NEXT-V-S],
        ';' => ['つく', $NEXT-V-S],
        'n' => ['とお', $NEXT-V-S],
        'm' => ['まちがえ', $NEXT-V-MURU],
        ',' => ['おわ', $NEXT-V-R],
        '.' => ['おえ', $NEXT-V-MURU],
    }
}


sub find-te(@arr,Str $katu,Str $tai,Str $TUNAGIKATA) returns Str {
    return 'はずれ' if !so @arr;
    #say "=====================$si\t$tai\t",@arr;
    my $temp = sub ___(@brr) {
        return if !so @brr;
        #say "Brr\t" ,@brr[0];
        return @arr[0] if @brr[0] eq $TUNAGIKATA;
        return  ___(@brr[1 ..*]);
    }(%katachi{$katu}{$tai}{@arr[0]});
    return $temp if so $temp;
    return  find-te(@arr[1 ..*], $katu, $tai, $TUNAGIKATA);
}


sub special_keys($si) {
    my %one = Hash.new(template-next-verb-te-e($si),
            {
                '2' => ['おもんばか', $NEXT-V-R],

                'q' => ['わか', $NEXT-V-R],
                'w' => ['よ', $NEXT-V-I],
                'e' => ['いらっしゃ', $NEXT-V-R-KEIGO],
                'r' => ['いただ', $NEXT-V-K],
                't' => ['ござ', $NEXT-V-R-KEIGO],
                'a' => ['はな', $NEXT-V-S],
                's' => ['おも', $NEXT-V-W],
                'd' => ['かんがえ', $NEXT-V-MURU],
                'f' => ['つか', $NEXT-V-W],
                #'f' => ['や', $NEXT-V-R],
                'g' => ['かえ', $NEXT-V-R],
                # い-変える is 一段R     て-返る/帰る  is 五段R
                'z' => ['くださ', $NEXT-V-R-KEIGO],
                'x' => ['しょうがな', $NEXT-V-I],
                'c' => ['しかたな', $NEXT-V-I],
                'v' => ['わる', $NEXT-V-I],
                'b' => ['たまらな', $NEXT-V-I],
            });
    my %two = Hash.new(template-next-verb-i-r($si), {});
    my %three = Hash.new(template-next-verb-i-t($si), {});

    return {
        $SP-ONE => %one,
        $NEXT-SP-ONE => %one,
        $SP-TWO => %two,
        $NEXT-SP-TWO => %two,
        $SP-THREE => %three,
        $NEXT-SP-THREE => %three,
    }
};
my @specials = [$SP-ONE, $SP-TWO, $SP-THREE,];
my @specials-next = [$NEXT-SP-ONE, $NEXT-SP-TWO, $NEXT-SP-THREE,];


sub generate-special(%g,Str $si,Str $katu,Bool $firstkey) {
    my (@k,@o,@n);
    sub injection($k,$o,$n) {
        @k.append($k);
        @o.append($o);
        @n.append($n);
    }
    #my %sp = special_keys($si);
    my Str ($bo,$out,$key,$next);
    my @arr = [$SP-ONE, $SP-TWO, $SP-THREE,];
    my @brr = [$NEXT-SP-ONE, $NEXT-SP-TWO, $NEXT-SP-THREE,];
    my @crr = ['て', 'い', 'い'];

    for %katachi{$katu}.keys -> $tai {
        for ^3 -> $ix {
            $bo = find-te(%katachi{$katu}{$tai}.keys, $katu, $tai, @crr[$ix]);
            $out = %g{$si}{$bo} ~ choose-sakippo($katu, $tai){@crr[$ix]};
            $key = %keylayout{$si} ~ %keylayout{$tai} ~ %keylayout{@arr[$ix]};
            $next = %keylayout{@brr[$ix]};
            say "$key\t$out\t$next";
            injection($key, $out, $next);
        }
    };
    if $firstkey {
        # ネガポジ判定
        my $tai;
        $tai = $NEUTRAL-PO if $katu ~~ $next-po-junction;
        # tai
        $tai = $NEUTRAL-NE if $katu ~~ $next-ne-junction;
        # tai
        $tai = $NEUTRAL-PO  if not so $tai;
        # next

        for ^3 -> $ix {
            $bo = find-te(%katachi{$katu}{$NEUTRAL-PO}.keys, $katu, $tai, @crr[$ix]);
            $out = %g{$si}{$bo} ~ choose-sakippo($katu, $tai){@crr[$ix]};
            $key = %keylayout{$si} ~ %keylayout{@arr[$ix]};
            $next = %keylayout{@brr[$ix]};
            injection($key, $out, $next);
        }
    }



    return result-print(@k, @o, @n);
}
sub parse-special(%sp) {
    # ,Str $befk,Str $befo){
    my (@k,@o,@n);
    sub injection($k,$o,$n) {
        @k.append($k);
        @o.append($o);
        @n.append($n);
    }
    my Str ($k,$o,$n);
    # ここにあるのと、それ以前の文字列やキーを足して出力すればいい
    # なんでわたしはこれまでネストの底がつくまでループしなかったんだろう？ネストカウントだって簡単なのに。
    # データの構造がいきあたりばったりのごちゃまぜだったからでしょ。
    for %sp.keys -> $k1 {
        for %sp{$k1}.keys -> $k2 {
            #say "aAAAAAAAAAA ", %sp{$k1}{$k2}[0];
            #            say "###",$k1;
            #           say "___",$k2;
            $k = %keylayout{$k1} ~ $k2;
            $o = %sp{$k1}{$k2}[0];
            $n = get-gyo-keys(%sp{$k1}{$k2}[1 ..*]);
            #say "$k\t$o\t$n";
            injection($k, $o, $n);
        }
    }
    return result-print(@k, @o, @n);
}

sub total-special(%g,$boo) {
    return parse-special(special_keys('n')) if !so %g;
    my %r;
    if $boo {
        for %g.keys {
            %r = Hash.new(%r, generate-special(%g, $_, choose-katu($_), True));
        }
    }else {
        for %g.keys {
            %r = Hash.new(%r, generate-special(%g, $_, choose-katu($_), False));
        }
    }
    return %r;
}

sub generate-next-verb(%g,Str $si,Str $katu,%verb-template,Str $TUNAGIKATA = 'て') {
    # Usage
    #  my %k-nexts = generate-next-verb(%gyo,'k',$KATU-GODAN,template-next-verb,'て');
    # 「て」か「い」でつなぐことを想定。「たら」とかからでもつなげられるが実用性は「て」「い」の2つだろう。
    my Str $ne-bo = find-te(%katachi{$katu}{$NEUTRAL-NE}.keys, $katu, $NEUTRAL-NE, $TUNAGIKATA);
    my Str $po-bo = find-te(%katachi{$katu}{$NEUTRAL-PO}.keys, $katu, $NEUTRAL-PO, $TUNAGIKATA);
    my $po-out = %g{$si}{$po-bo} ~ choose-sakippo($katu, $NEUTRAL-PO){$TUNAGIKATA};
    my $ne-out = %g{$si}{$ne-bo} ~ choose-sakippo($katu, $NEUTRAL-NE){$TUNAGIKATA};
    # NONE につっこんでる連中はどうするのか？それは出力文字を一旦はかせて適切な値をもらえばいいじゃない。
    sub test() {
        say "\$si\t\t$si";
        say "\$po-bo\t\t", $po-bo, "\t", %g{$si}{$po-bo}, "\t", choose-sakippo($katu, $NEUTRAL-PO){$TUNAGIKATA};
        say "\$ne-bo\t\t", $ne-bo, "\t", %g{$si}{$ne-bo}, "\t", choose-sakippo($katu, $NEUTRAL-NE){$TUNAGIKATA};
    }();
    return {
        $NEUTRAL-PO => {
            $po-out => %verb-template
            #%g{$si}{'te'} => %verb-template
        }, $NEUTRAL-NE => {
            $ne-out => %verb-template
        }
    }
}
sub parse-next-verb(%verbs) {
    # returns Hash {
    my (@k,@o,@n);
    sub injection($k,$o,$n) {
        @k.append($k);
        @o.append($o);
        @n.append($n);
    }

    my Str ($key, $output, $next);
    sub _1(@key1) {
        return if !so @key1;
        sub _2(@key2) {
            return if !so @key2;
            sub _3(@out1) {
                return if !so @out1;
                sub _4(@key3) {
                    return if !so @key3;
                    $key = %keylayout{@key1[0]} ~ %keylayout{@key2[0]} ~ @key3[0];
                    $output = @out1[0] ~ %verbs{@key1[0]}{@key2[0]}{@out1[0]}{@key3[0]}[0];
                    $next = get-gyo-keys(%verbs{@key1[0]}{@key2[0]}{@out1[0]}{@key3[0]}[1 ..*]);
                    #say "$key\t\t$output\t\t$next";
                    injection($key, $output, $next);

                    return  _4(@key3[1 ..*]);
                }(%verbs{@key1[0]}{@key2[0]}{@out1[0]}.keys);
                return  _3(@out1[1 ..*]);
            }(%verbs{@key1[0]}{@key2[0]}.keys);
            return  _2(@key2[1 ..*]);
        }(%verbs{@key1[0]}.keys);
        return _1(@key1[1 ..*]);
    }(%verbs.keys);
    return result-print(@k, @o, @n);
}
sub total-next-verb(%g) returns Hash {
    my %r is Hash;
    { %r{$_} = generate-next-verb(%g, $_, choose-katu($_), template-next-verb-te-e($_)); } for %g.keys;
    return parse-next-verb(%r);
}
sub total-tai-next-verb(%g) {
    # やるき？ないよ、そんなもの。きれいに書く気力がないです。
    sub vb(%g,Str $si,Str $katu) {
        my (@k,@o,@n);
        sub injection($k,$o,$n) {
            @k.append($k);
            @o.append($o);
            @n.append($n);
        }
        my Str ($bo,$out,$key,$next);
        my Str $TNG = 'て';
        my %verbs = template-next-verb-te-e('n');

        my $tai;
        $tai = $NEUTRAL-PO;

        for %verbs.keys {
            $bo = find-te(%katachi{$katu}{$NEUTRAL-PO}.keys, $katu, $tai, $TNG);
            $out = %g{$si}{$bo} ~ choose-sakippo($katu, $tai){$TNG} ~ %verbs{$_}[0];
            $key = %keylayout{$si} ~ $_;
            $next = %keylayout{%verbs{$_}[1]};
            injection($key, $out, $next);
        }
        return result-print(@k, @o, @n);
    }
    my %r;
    for %g.keys {
        %r = Hash.new(%r, vb(%g, $_, choose-katu($_)));
    }
    return %r;
}


# ====================================================================

sub hash-to-write(%h,$filename) {
    # key でソートすると設定が見やすくていいですね。Mapなので重複しようがないってのも良さのうち。
    my $f = open $filename, :w;
    my Str $s;
    for %h.keys.sort -> $k {
        my $v = %h{$k};
        $s = $k ~ "\t" ~ $v[0];
        $s ~= "\t" ~ $v[1]  if so $v[1];
        $f.say($s);
    }
    $f.close;
}



sub MAIN() {
    sub 例外(%r)  {
        # ダ行の連用形と接辞のつながりを変更。打つ価値もないだろうが「な」は残す。
        my @arr = ['hir','hkr','h@r','h:r','hit','hkt','h@t','h:t',];
        %r{$_}[0] = 'に' if %r{$_}[0]:exists for @arr; # 狙い撃ち

        # 形容詞の連用形「クテ」は「て」ないほうがいい。接続しない形でのテ形は残す。
        %r{$_}[0] = %r{$_}[0].subst(/くて/,'く') if so %r{$_}[1] for %r.keys;

        # 一段活用の空出力には「し」をあてがう。妥協措置なので、つなぐときは「し」が入ってなくていいし、「空文字」のまま動作するならそのほうが望ましい。
        %r{$_}[0] = 'し' if (not so %r{$_}[1]) and (not so %r{$_}[0]) for %r.keys;

        return %r;
        # 形容詞の仕様は最後の最後まで決定しませんでしたね。気力がなさすぎたんで。保たなかったんですよ
        # 動詞とは別物を動詞と同列に扱おうってのもまずむりがあったんじゃないか？形容詞に態なんてなかったんだし。態からも形容詞化できるし。
    }
    sub write() {
        my $fn = "長鳴き鳥配列-拡張のみ.txt";
        my %r;
        %r = Hash.new(
                # 接辞右側（形）
                例外(left-default-katachi(%gyo-next, $NEUTRAL-PO)),
                # 接辞左側（NEUTRAL態のみ）
                例外(left-default-katachi(%gyo-tai, '')),

                # 「行 → NEUTRAL態 → 右手」パターン   右右右3打
                例外(total-next-verb(%gyo)),
                例外(total-next-verb(%gyo-next)),
                例外(total-tai-next-verb(%gyo-tai));

                # 「行 → NEUTRAL以外の態」  「行」から「態」へつながる右右2打。
                gyo-to-tai(%gyo),
                gyo-to-tai(%gyo-next),

                # 「主にNEUTRAL態 → 左手」パターン   右右左3打
                例外(ironna-katachi(%gyo)),
                例外(ironna-katachi(%gyo-next)),

                # 「⭐❤️🔪」
                total-special(Map.new, False),
                # 行なし
                例外(total-special(%gyo, False)),
                # 態なし2打 を含む
                例外(total-special(%gyo-next, True)),
                total-special(%gyo-tai, True),
                );
        #%r = 例外(%r),
        hash-to-write(%r, $fn);
        # 残りの処理
        # 検証と修正
    }
    write();

}